-- ============================================================================
-- File:        parallel.sql
--
-- Process:     Set a session's parallism
--
-- Requires:    Connection to DB 
--
-- Usage (SQL): START parallel.sql degree
--
-- ============================================================================

define lDegree = &1

declare
  lDegree integer := &lDegree ;
begin
  commit;
  if lDegree = 0 then
    execute immediate 'ALTER SESSION DISABLE PARALLEL DDL  ' ;
    execute immediate 'ALTER SESSION DISABLE PARALLEL DML  ' ;
    execute immediate 'ALTER SESSION DISABLE PARALLEL QUERY' ;
  else
    execute immediate 'ALTER SESSION FORCE PARALLEL DDL   PARALLEL ' || to_char(lDegree);
    execute immediate 'ALTER SESSION FORCE PARALLEL DML   PARALLEL ' || to_char(lDegree);
    execute immediate 'ALTER SESSION FORCE PARALLEL QUERY PARALLEL ' || to_char(lDegree);
  end if;
end;
/
